/*
  Attachment Extracting
  for Iconfactory's Tapestry plugins

  Grabs urls from a string, like `content_html` in a JSON Feed, and makes them attachments.

  Made to be used in your Tapestry plugins like so:

  ```js
    const myItem = Item.createWithUriDate(url, date);
    myItem.attachments = extractAttachments(content_html, [rest?.external_url, rest?.image])
  ```
*/

const URL_REGEX =
  /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&//=]*)/g;
const MEDIA_EXT = ["png", "tif", "tiff", "jpeg", "jpg", "gif", "bmp", "bmpf", "ico", "cur", "xbm", "aac", "aiff", "aifc", "avi", "ac3", "mp4", "m2v", "ts", "mpg", "mp2", "mp3", "au", "3gp", "3g2"];

function extractAttachments(from = "", exclude = []) {
  return (from.match(URL_REGEX) || [])
    .filter((url) => !exclude.includes(url))
    .map((url) =>
      MEDIA_EXT.some((ext) => url.includes(`.${ext}`))
        ? MediaAttachment.createWithUrl(url)
        : LinkAttachment.createWithUrl(url)
    );
}
