_From the blog post [I Made a Mastodon and Bluesky Client](https://melkat.blog/p/mastodon-bsky-app/)_

## Usage

### Bluesky

#### Install dependencies

```sh
npm i --save @atproto/api
```


#### Customize server

```diff
- const agent = new AtpAgent({ service: "https://melkat.blue" });
+ const agent = new AtpAgent({ service: "Your Bluesky PDS" });
```


#### Example usage

```js
import { buildJsonFeed, getTimeline } from "./bluesky.js";

const timeline = await getTimeline(identifier, appPassword);
buildJsonFeed(identifier, timeline)
```


### Mastodon

#### Install dependencies

```sh
npm i --save sanitize-html undici
```


#### Customize server

```diff
- const MASTODON_HOST = "https://nyan.lol";
+ const MASTODON_HOST = "Your Mastodon Host";
```


#### Example usage

```js
import { buildJsonFeed, getTimeline, getUser } from "./mastodon.js";

const user = await getUser(token);
const timeline = await getTimeline(token);
buildJsonFeed(user, timeline)
```