const config = {
  ACCESS_KEY: "",
  CLEANUP: false,
  DEBUG: false,
  PULL_ZONES: [69, 420],
};

const consts = {
  AI_ROBOTS_FILE:
    "https://raw.githubusercontent.com/ai-robots-txt/ai.robots.txt/main/robots.txt",
  API_HOST: "https://api.bunny.net/pullzone/",
  EDGE_RULE_TITLE: "Block AI Bots",
  PREFIX: "🐰🚫🤖",
};

function chunk(arr, size, initArray = []) {
  const cpy = [...arr];
  if (size <= 0) {
    return initArray;
  }
  while (cpy.length) {
    initArray.push(cpy.splice(0, size));
  }
  return initArray;
}

async function cleanupPullZone(pullZoneId) {
  const res = await fetch(`${consts.API_HOST}${pullZoneId}`, {
    headers: {
      "content-type": "application/json",
      AccessKey: config.ACCESS_KEY,
    },
  });
  const data = await res.json();
  const guids = data.EdgeRules.filter(({ Description }) =>
    Description.includes(consts.EDGE_RULE_TITLE)
  ).map(({ Guid }) => Guid);

  guids.map(async (guid) => {
    const res = await fetch(
      `${consts.API_HOST}${pullZoneId}/edgerules/${guid}`,
      {
        method: "DELETE",
        headers: {
          "content-type": "application/json",
          AccessKey: config.ACCESS_KEY,
        },
      }
    );
    const data = await res.json();
    console.log(`${consts.PREFIX} ${pullZoneId}: Deleted edge rule ${guid}`);
    if (config.DEBUG) {
      console.log(data);
    }
  });
}

async function cleanup() {
  console.log(`${consts.PREFIX} Running clean up`);
  config.PULL_ZONES.flatMap((pullZoneId) => cleanupPullZone(pullZoneId));
  console.log(`${consts.PREFIX} Done cleaning up`);
}

function buildTriggers(robots) {
  return chunk(robots, 5).map((PatternMatches) => ({
    Type: 1,
    PatternMatchingType: 0,
    PatternMatches: PatternMatches.map((i) => `*${i}*`),
    Parameter1: "User-Agent",
  }));
}

async function fetchRobots() {
  return await fetch(consts.AI_ROBOTS_FILE)
    .then((res) => res.text())
    .then((txt) =>
      txt
        .replaceAll("User-agent: ", "")
        .replace("\nDisallow: /\n", "")
        .split("\n")
    );
}

async function createEdgeRules(triggers) {
  const triggerChunks = chunk(triggers, 5);
  for (const pullZoneID of config.PULL_ZONES) {
    for (const Triggers of triggerChunks) {
      const idx = triggerChunks.indexOf(Triggers);
      const res = await fetch(
        `${consts.API_HOST}${pullZoneID}/edgerules/addOrUpdate`,
        {
          method: "POST",
          headers: {
            "content-type": "application/json",
            AccessKey: config.ACCESS_KEY,
          },
          body: JSON.stringify({
            ActionType: 4,
            TriggerMatchingType: 0,
            Enabled: true,
            Triggers,
            Description: `${consts.EDGE_RULE_TITLE}, Group ${idx + 1}`,
          }),
        }
      );
      const data = await res.json();
      console.log(`${consts.PREFIX} ${pullZoneID}: Processed batch ${idx + 1}`);
      if (config.DEBUG) {
        console.log(data);
      }
    }
  }
}

console.log(
  `${consts.PREFIX} Preparing to work on pullzones: ${config.PULL_ZONES.join(
    ", "
  )}`
);

if (config.CLEANUP) {
  await cleanup();
}

const robots = await fetchRobots();
const triggers = buildTriggers(robots);
await createEdgeRules(triggers);

console.log(`${consts.PREFIX} Completed creating edge rules.`);
