# Johnny Decimal Index Generator for Obsidian with Dataview

You will need to enable JavaScript Queries in the Dataview settings.

```dataviewjs
let areas = dv.pages("").file.folder.groupBy(g=>g.split("/")[0]).filter(({ key }) => /^\d{2}-\d{2} /.test(key))
let output = ''
areas.forEach(({ key: areaKey, rows: areaRows }) => {
  output += `\n- ${areaKey}`
  areaRows.groupBy(g => g.split("/")[1]).forEach(({ key: categoryKey, rows: categoryRows }) => {
    if (/^\d{2} /.test(categoryKey)) {
      output += `\n  - ${categoryKey}`
      dv.pages(`"${areaKey}/${categoryKey}"`).file.forEach(({ link: contentKey }) => {
        output += `\n    - ${contentKey}`
      })
    }
  })
})
dv.paragraph(output)
```

## Output

- 00-09 System
  - 00 Index
    - [00.00 Index]()
  - 01 Inbox
    - [01.00 Inbox]()
    - [01.01 Scratchpad]()
  - 02 Notes
    - [02.00 Notes]()
  - 03 TODOs
    - [03.00 TODOs]()
  - 04 Bookmarks
    - [04.00 Bookmarks]()
  - 05 Templates
    - [05.00 Templates]()
  - 08 Someday
    - [08.00 Someday]()
  - 09 Archive
    - [09.00 Archive]()


## Links

- [Johnny Decimal](https://johnnydecimal.com)
- [Obsidian](https://obsidian.md)
- [obsidian-dataview](https://github.com/blacksmithgu/obsidian-dataview)
