# Make Git always use `main` as default branch

## Git 2.28.0

```sh
git config --global init.defaultBranch main
```


## Pre-Git 2.28.0

```sh
mkdir -p ~/.config/git/templates/default
echo "ref: refs/heads/main" > ~/.config/git/templates/default/HEAD
git config --global init.templateDir '~/.config/git/templates/default'
```


## Make main your main

`git branch -m master main && git push -u origin main`

Next, tell GitHub or whoever your new default is `main`. Then you can tell the remote repo to destroy the old branch:

`git push origin :master`
