// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: deep-blue; icon-glyph: theater-masks;

// Your reporting group number:
const GROUP_NUMBER = 69

const PAGE =
  'https://www.sfsuperiorcourt.org/divisions/jury-services/jury-reporting'
const REPORTING = 'REPORTING'
const STANDBY = 'STANDBY'
const SAFE = 'safe'
const WANTED = 'wanted'
const UNCLEAR = 'unclear'

const RE_HTML = /<\/?[\w\s]*>|<.+[\W]>/g
const RE_RESULTS = new RegExp(
  `GROUPS.*?:\s?\nGroups.*${GROUP_NUMBER}.*?\n`,
  'g'
)

const COLOR_RED = new Color('#FF9580')
const COLOR_GREEN = new Color('#8AFF80')

const fetchPage = async (URL) => {
  const req = new Request(URL)
  const str = await req.loadString()
  return str.replace(RE_HTML, '')
}

const getResults = async () => {
  const data = await fetchPage(PAGE)
  const results = data.match(RE_RESULTS)
  return results ? results.join('') : ''
}

const getType = (results) => {
  if (results.indexOf(STANDBY) !== -1) {
    return SAFE
  }
  if (results.indexOf(REPORTING) !== -1) {
    return WANTED
  }
  return UNCLEAR
}

const makeWidget = async () => {
  const results = await getResults()
  const type = getType(results)

  const widget = new ListWidget()
  const gradient = new LinearGradient()
  gradient.colors = [new Color('#000'), new Color('#000')]
  gradient.locations = [0, 1]
  widget.backgroundGradient = gradient

  const textStack = widget.addStack()
  textStack.layoutVertically()
  textStack.centerAlignContent()

  const textPrefix = textStack.addText('You are')
  textPrefix.font = Font.semiboldRoundedSystemFont(16)
  textPrefix.textColor = new Color('#F8F8F2')
  textPrefix.leftAlignText()

  const textTitle = textStack.addText(type)
  textTitle.font = Font.boldRoundedSystemFont(32)
  textTitle.textColor = type === WANTED ? COLOR_RED : COLOR_GREEN
  textTitle.leftAlignText()

  widget.url = PAGE

  return widget
}

const widget = await makeWidget()
if (config.runsInWidget) {
  Script.setWidget(widget)
  Script.complete()
} else {
  widget.presentSmall()
}
