#!/bin/bash

if [ $# -ne 1 ]; then
    echo "Usage: $0 <file>"
    exit 1
fi

input_file="$1"

if [ ! -f "$input_file" ]; then
    echo "File not found: $input_file"
    exit 1
fi

while IFS= read -r ip_address; do
    echo "Performing nslookup for $ip_address"
    nslookup "$ip_address"
    echo "-----"
done < "$input_file"
