// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: green; icon-glyph: archive;
// unpkg: like NPM but not as good
//        and available in Scriptable
//
// Examples:
// - const _ = await unpkg('lodash')
// - const CryptoJS = await unpkg('crypto-js')
// - const OAuth = await unpkg('oauth-1.0a')

const unpkg = (package, file, version) => {
  return new Promise((callback) => {
    const jsFile = file || package
    const pkgVersion = version ? `@${version}` : ''
    const fm = FileManager.iCloud()
    const modulesPath = fm.joinPath(fm.documentsDirectory(), 'modules/')
    const modulePath = fm.joinPath(modulesPath, `${package}${pkgVersion}/`)
    const filePath = fm.joinPath(modulePath, `${jsFile.split('/')[jsFile.split('/').length-1]}.js`)

    if (!fm.fileExists(modulePath)) {
      fm.createDirectory(modulePath, true)
    }
    if (!fm.fileExists(filePath) ) {
      const req = new Request(`https://unpkg.com/${package}${pkgVersion}/${jsFile}.js`)
      req.loadString().then(res => {
        fm.writeString(filePath, `${res}`).then(() => {
          callback(importModule(filePath))
        })
      })
    } else {
      fm.downloadFileFromiCloud(filePath).then(() => {
        callback(importModule(filePath))
      })
    }
  })
}

module.exports = unpkg
