<?php

$YOUR_NAME = 'Melanie';
$WEBSITE_PATH = 'http://ds423/audio-cast';

$audioDirectory = '.';

$audioFiles = glob($audioDirectory . '/*.{mp3,m4a}', GLOB_BRACE);
usort($audioFiles, function ($a, $b) {
    return filemtime($b) - filemtime($a);
});

$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>
<rss version=\"2.0\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">
    <channel>
        <title>{$YOUR_NAME}'s Audio Cast</title>
        <link>{$WEBSITE_PATH}</link>
        <description>Audio files in a folder as a podcast.</description>
        <language>en-us</language>
";

foreach ($audioFiles as $audioFile) {
    $title = pathinfo($audioFile, PATHINFO_FILENAME);
    $extension = pathinfo($audioFile, PATHINFO_EXTENSION);
    $pubDate = date(DATE_RSS, filemtime($audioFile));
    $fileLink = $WEBSITE_PATH . "/" . rawurlencode($title) . "." . $extension;

    $xml .=
        "
        <item>
            <title>{$title}</title>
            <link>{$fileLink}</link>
            <description>{$title}</description>
            <enclosure url=\"{$fileLink}\" length=\"" .
        filesize($audioFile) .
        "\" type=\"audio/mpeg\" />
            <guid isPermaLink=\"false\">{$title}</guid>
            <pubDate>{$pubDate}</pubDate>
        </item>
    ";
}

$xml .= '
    </channel>
</rss>
';

echo $xml;
?>
